/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.swing.PHyperlink;
import edu.princeton.swing.PList;
import edu.princeton.swing.PTextField;
import edu.princeton.toy.lang.TVirtualMachine;
import edu.princeton.toy.lang.TWord;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TCorePane
extends JPanel {
    private static final String CLASS_STRING = TCorePane.class.toString();
    public static final String UPDATE_COMMAND = CLASS_STRING + "#updateCommand";
    private JTextField instructionTextField;
    private JTextField pcTextField;
    private DefaultListModel registerModel;
    private DefaultListModel memModel;
    private boolean distinguishUninitialized;
    private TWord programCtr;
    private TWord instruction;
    private TWord[] registers;
    private TWord[] mem;
    private PHyperlink saveMemDumpLink;
    private PHyperlink saveCoreDumpLink;
    private TVirtualMachine virtualMachine;
    private Listener listener;

    public TCorePane(TVirtualMachine virtualMachine, Action saveMemDumpAction, Action saveCoreDumpAction) {
        super(new GridBagLayout(), true);
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        this.virtualMachine = virtualMachine;
        this.registers = new TWord[16];
        this.mem = new TWord[256];
        this.listener = new Listener();
        virtualMachine.addChangeListener(this.listener);
        this.add((Component)new JLabel("Core"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.saveCoreDumpLink = new PHyperlink(saveCoreDumpAction, 3);
        this.saveCoreDumpLink.setText("Save Core Dump...");
        this.add((Component)this.saveCoreDumpLink, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("Program Counter"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.pcTextField = new PTextField();
        this.pcTextField.setEditable(false);
        this.pcTextField.setFont(null);
        this.add((Component)this.pcTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("Current Instruction"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.instructionTextField = new PTextField();
        this.instructionTextField.setEditable(false);
        this.instructionTextField.setFont(null);
        this.add((Component)this.instructionTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setFont(null);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setFont(null);
        panel.add((Component)new JLabel("Registers"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.registerModel = new DefaultListModel();
        this.registerModel.ensureCapacity(16);
        for (int ctr = 0; ctr < 16; ++ctr) {
            this.registerModel.addElement("");
        }
        PList list = new PList((ListModel)this.registerModel);
        list.setFont(null);
        JScrollPane scrollPane = new JScrollPane(list, 22, 30);
        scrollPane.setFont(null);
        scrollPane.getViewport().setFont(null);
        panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        splitPane.setTopComponent(panel);
        panel = new JPanel(new GridBagLayout());
        panel.setFont(null);
        panel.add((Component)new JLabel("Memory"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.saveMemDumpLink = new PHyperlink(saveMemDumpAction, 3);
        this.saveMemDumpLink.setText("Save Memory Dump...");
        panel.add((Component)this.saveMemDumpLink, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.memModel = new DefaultListModel();
        this.memModel.ensureCapacity(256);
        for (int ctr = 0; ctr < 256; ++ctr) {
            this.memModel.addElement("");
        }
        list = new PList((ListModel)this.memModel);
        list.setFont(null);
        scrollPane = new JScrollPane(list, 22, 30);
        scrollPane.setFont(null);
        scrollPane.getViewport().setFont(null);
        panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        splitPane.setBottomComponent(panel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(0.4);
        splitPane.setResizeWeight(0.4);
        this.add((Component)splitPane, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.doCommand(UPDATE_COMMAND, null);
    }

    public void setVirtualMachine(TVirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        if (this.virtualMachine == virtualMachine) {
            return;
        }
        this.virtualMachine.removeChangeListener(this.listener);
        virtualMachine.addChangeListener(this.listener);
        this.virtualMachine = virtualMachine;
        this.doCommand(UPDATE_COMMAND, null);
    }

    public TVirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public synchronized boolean doCommand(String command, Object extraInfo) {
        if (command == UPDATE_COMMAND) {
            boolean newDistinguishUninitialized = this.virtualMachine.getDistinguishUninitialized();
            boolean oldDistinguishUninitialized = this.distinguishUninitialized;
            this.distinguishUninitialized = newDistinguishUninitialized;
            if (newDistinguishUninitialized != oldDistinguishUninitialized) {
                int ctr;
                TWord newValue = this.programCtr = this.virtualMachine.getProgramCtr();
                this.pcTextField.setText(newValue.toString(false));
                this.pcTextField.setCaretPosition(0);
                newValue = this.instruction = this.virtualMachine.getCurrentInstruction();
                this.instructionTextField.setText(newValue.toHexString(this.distinguishUninitialized) + " (" + newValue.toPseudoCodeString(this.distinguishUninitialized) + ")");
                this.instructionTextField.setCaretPosition(0);
                for (ctr = 0; ctr < 16; ++ctr) {
                    newValue = this.registers[ctr] = this.virtualMachine.getRegister(ctr);
                    this.registerModel.set(ctr, "R[" + TWord.HEX_DIGITS[ctr] + "] = " + newValue.toString(this.distinguishUninitialized));
                }
                for (ctr = 0; ctr < 256; ++ctr) {
                    newValue = this.mem[ctr] = this.virtualMachine.getMem(ctr);
                    if (ctr < TVirtualMachine.PC_START_VALUE) {
                        this.memModel.set(ctr, "M[" + TWord.HEX_PAIRS[ctr] + "] = " + newValue.toString(this.distinguishUninitialized));
                        continue;
                    }
                    this.memModel.set(ctr, "M[" + TWord.HEX_PAIRS[ctr] + "] = " + newValue.toHexString(this.distinguishUninitialized) + " (" + newValue.toPseudoCodeString(this.distinguishUninitialized) + ")");
                }
            } else {
                short ctr;
                TWord oldValue = this.programCtr;
                this.programCtr = this.virtualMachine.getProgramCtr();
                TWord newValue = this.programCtr;
                if (oldValue != newValue) {
                    this.pcTextField.setText(newValue.toString(false));
                    this.pcTextField.setCaretPosition(0);
                }
                if ((oldValue = this.instruction) != (newValue = (this.instruction = this.virtualMachine.getCurrentInstruction()))) {
                    this.instructionTextField.setText(newValue.toHexString(this.distinguishUninitialized) + " (" + newValue.toPseudoCodeString(this.distinguishUninitialized) + ")");
                    this.instructionTextField.setCaretPosition(0);
                }
                for (ctr = 0; ctr < 16; ++ctr) {
                    oldValue = this.registers[ctr];
                    this.registers[ctr] = this.virtualMachine.getRegister(ctr);
                    newValue = this.registers[ctr];
                    if (oldValue == newValue) continue;
                    this.registerModel.set(ctr, "R[" + TWord.HEX_DIGITS[ctr] + "] = " + newValue.toString(this.distinguishUninitialized));
                }
                for (ctr = 0; ctr < 256; ++ctr) {
                    oldValue = this.mem[ctr];
                    this.mem[ctr] = this.virtualMachine.getMem(ctr);
                    newValue = this.mem[ctr];
                    if (oldValue == newValue) continue;
                    if (ctr < TVirtualMachine.PC_START_VALUE) {
                        this.memModel.set(ctr, "M[" + TWord.HEX_PAIRS[ctr] + "] = " + newValue.toString(this.distinguishUninitialized));
                        continue;
                    }
                    this.memModel.set(ctr, "M[" + TWord.HEX_PAIRS[ctr] + "] = " + newValue.toHexString(this.distinguishUninitialized) + " (" + newValue.toPseudoCodeString(this.distinguishUninitialized) + ")");
                }
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    protected class Listener
    implements ChangeListener {
        protected Listener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TCorePane.this.doCommand(UPDATE_COMMAND, null);
        }
    }
}

